/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.internal.hyperlink;

import com.aptana.terminal.hyperlink.IHyperlinkDetector;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;

public class URLHyperlinkDetector
implements IHyperlinkDetector {
    private static final Pattern URL_DETECT_PATTERN = Pattern.compile("\\b\n  # Match the leading part (proto://hostname, or just hostname)\n  (\n    # http://, or https:// leading part\n    (https?)://[-\\w]+(\\.\\w[-\\w]*)+\n  |\n    # or, try to find a hostname with more specific sub-expression\n    (?i: [a-z0-9] (?:[-a-z0-9]*[a-z0-9])? \\. )+ # sub domains\n    # Now ending .com, etc. For these, require lowercase\n    (?-i: com\\b\n        | edu\\b\n        | biz\\b\n        | gov\\b\n        | in(?:t|fo)\\b # .int or .info\n        | mil\\b\n        | net\\b\n        | org\\b\n        | [a-z][a-z]\\.[a-z][a-z]\\b # two-letter country code\n    )\n  )\n\n  # Allow an optional port number\n  ( : \\d+ )?\n\t\t  \n  # The rest of the URL is optional, and begins with /\n  (\n    /\n    # The rest are heuristics for what seems to work well\n    [^.!,?;\"\\'<>()\\[\\]\\{\\}\\s\\x7F-\\xFF]*\n    (\n      [.!,?]+ [^.!,?;\"\\'<>()\\[\\]\\{\\}\\s\\x7F-\\xFF]+\n    )*\n  )?", 6);

    public IHyperlink[] detectHyperlinks(String contents) {
        ArrayList<URLHyperlink> list = new ArrayList<URLHyperlink>();
        Matcher m = URL_DETECT_PATTERN.matcher(contents);
        int start = 0;
        while (m.find(start)) {
            String urlString = m.group().trim();
            start = m.end();
            Region region = new Region(m.start(), urlString.length());
            if (!urlString.startsWith("http://")) {
                urlString = "http://" + urlString;
            }
            list.add(new URLHyperlink((IRegion)region, urlString));
        }
        return list.toArray(new IHyperlink[list.size()]);
    }
}

